<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $full_width
 * @var $full_height
 * @var $columns_placement
 * @var $content_placement
 * @var $parallax
 * @var $parallax_image
 * @var $css
 * @var $el_id
 * @var $video_bg
 * @var $video_bg_url
 * @var $video_bg_parallax
 * @var $parallax_speed_bg
 * @var $parallax_speed_video
 * @var $content - shortcode content
 * @var $css_animation
 * Shortcode class
 * @var WPBakeryShortCode_Vc_Row $this
 */
$el_class        = $full_height = $parallax_speed_bg = $parallax_speed_video = $full_width = $flex_row = $columns_placement = $content_placement = $parallax = $parallax_image = $css = $el_id = $video_bg = $video_bg_url = $video_bg_parallax = $css_animation = $top_divider_type = $top_divider_custom = $top_divider_color = $top_divider_height = $top_divider_flip = $top_divider_invert = $bottom_divider_type = $bottom_divider_custom = $bottom_divider_color = $bottom_divider_height = $bottom_divider_flip = $bottom_divider_invert = $is_container = $top_divider_class = $bottom_divider_class = $conditional_render = '';
$disable_element = '';
$output          = $after_output = '';
$atts            = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );
$conditional_render = (array) vc_param_group_parse_atts( $conditional_render );
if ( ! empty( $conditional_render ) && ! empty( $conditional_render[0]['condition_a'] ) && ! apply_filters( 'porto_wpb_should_render', true, $conditional_render ) ) {
	return;
}
if ( 'none' == $top_divider_type ) {
	$top_divider_type = '';
}
if ( 'none' == $bottom_divider_type ) {
	$bottom_divider_type = '';
}

wp_enqueue_script( 'wpb_composer_front_js' );

$el_class = $this->getExtraClass( $el_class ) . $this->getCSSAnimation( $css_animation );

$css_classes = array(
	'vc_section',
	$el_class,
	vc_shortcode_custom_css_class( $css ),
);

if ( ! ( empty( $top_divider_type ) && empty( $bottom_divider_type ) ) ) {
	$css_classes[] = 'section-with-shape-divider';
}

if ( 'yes' === $disable_element ) {
	if ( vc_is_page_editable() ) {
		$css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
	} else {
		return '';
	}
}

if ( vc_shortcode_custom_css_has_property(
	$css,
	array(
		'border',
		'background',
	)
) || $video_bg || $parallax
) {
	$css_classes[] = 'vc_section-has-fill';
}


$wrapper_attributes = array();
// build attributes for wrapper
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}
if ( ! empty( $full_width ) ) {
	$wrapper_attributes[] = 'data-vc-full-width="true"';
	$wrapper_attributes[] = 'data-vc-full-width-init="false"';
	if ( 'stretch_row_content' === $full_width ) {
		$wrapper_attributes[] = 'data-vc-stretch-content="true"';
	}
	$after_output .= '<div class="vc_row-full-width vc_clearfix"></div>';
}

if ( ! empty( $full_height ) ) {
	$css_classes[] = 'vc_row-o-full-height';
}

if ( ! empty( $content_placement ) ) {
	$flex_row      = true;
	$css_classes[] = 'vc_section-o-content-' . $content_placement;
}

if ( ! empty( $flex_row ) ) {
	$css_classes[] = 'vc_section-flex';
}

$has_video_bg = ( ! empty( $video_bg ) && ! empty( $video_bg_url ) && vc_extract_youtube_id( $video_bg_url ) );

$parallax_speed = $parallax_speed_bg;
if ( $has_video_bg ) {
	$parallax       = $video_bg_parallax;
	$parallax_speed = $parallax_speed_video;
	$parallax_image = $video_bg_url;
	$css_classes[]  = 'vc_video-bg-container';
	wp_enqueue_script( 'vc_youtube_iframe_api_js' );
}

if ( ! empty( $parallax ) ) {
	wp_enqueue_script( 'vc_jquery_skrollr_js' );
	$wrapper_attributes[] = 'data-vc-parallax="' . esc_attr( $parallax_speed ) . '"'; // parallax speed
	$css_classes[]        = 'vc_general vc_parallax vc_parallax-' . $parallax;
	if ( false !== strpos( $parallax, 'fade' ) ) {
		$css_classes[]        = 'js-vc_parallax-o-fade';
		$wrapper_attributes[] = 'data-vc-parallax-o-fade="on"';
	} elseif ( false !== strpos( $parallax, 'fixed' ) ) {
		$css_classes[] = 'js-vc_parallax-o-fixed';
	}
}

if ( ! empty( $parallax_image ) ) {
	if ( $has_video_bg ) {
		$parallax_image_src = $parallax_image;
	} else {
		$parallax_image_id  = preg_replace( '/[^\d]/', '', $parallax_image );
		$parallax_image_src = wp_get_attachment_image_src( $parallax_image_id, 'full' );
		if ( ! empty( $parallax_image_src[0] ) ) {
			$parallax_image_src = $parallax_image_src[0];
		}
	}
	$wrapper_attributes[] = 'data-vc-parallax-image="' . esc_attr( $parallax_image_src ) . '"';
}
if ( ! $parallax && $has_video_bg ) {
	$wrapper_attributes[] = 'data-vc-video-bg="' . esc_attr( $video_bg_url ) . '"';
}
$css_class            = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';

$output .= '<section ' . implode( ' ', $wrapper_attributes ) . '>';
if ( ! empty( $top_divider_type ) ) {
	$top_divider_attr = array(
		'shape-divider',
	);
	if ( ! empty( $top_divider_class ) ) {
		$top_divider_attr[] = $top_divider_class;
	}
	if ( ! empty( $top_divider_invert ) && ! empty( $top_divider_flip ) ) {
		$top_divider_attr[] = 'shape-divider-reverse-xy';
	} elseif ( ! empty( $top_divider_invert ) ) {
		$top_divider_attr[] = 'shape-divider-reverse-x';
	} elseif ( ! empty( $top_divider_flip ) ) {
		$top_divider_attr[] = 'shape-divider-reverse-y';
	}
	if ( ! empty( $top_divider_height ) ) {
		$unit = preg_replace( '/[0-9.]/', '', $top_divider_height );
		if ( ! $unit ) {
			$top_divider_height .= 'px';
		}
	}

	$output .= '<div class="' . esc_attr( implode( ' ', $top_divider_attr ) ) . '" style="' . ( empty( $top_divider_color ) ? '' : 'fill:' . esc_attr( $top_divider_color ) . ';' ) . ( empty( $top_divider_height ) ? '' : 'height:' . esc_attr( $top_divider_height ) . ';' ) . '">';
	if ( 'custom' == $top_divider_type ) {
		$output .= rawurldecode( base64_decode( porto_strip_script_tags( $top_divider_custom ) ) );
	} else {
		$output .= porto_sh_commons( 'shape_divider' )[ $top_divider_type ];
	}
	$output .= '</div>';
}
if ( ! empty( $is_container ) ) {
	$output .= '<div class="container">';
}
$output .= wpb_js_remove_wpautop( $content );
if ( ! empty( $is_container ) ) {
	$output .= '</div>';
}
if ( ! empty( $bottom_divider_type ) ) {
	$bottom_divider_attr = array(
		'shape-divider shape-divider-bottom',
	);
	if ( ! empty( $bottom_divider_class ) ) {
		$bottom_divider_attr[] = $bottom_divider_class;
	}
	if ( ! empty( $bottom_divider_invert ) && ! empty( $bottom_divider_flip ) ) {
		$bottom_divider_attr[] = 'shape-divider-reverse-xy';
	} elseif ( ! empty( $bottom_divider_invert ) ) {
		$bottom_divider_attr[] = 'shape-divider-reverse-x';
	} elseif ( ! empty( $bottom_divider_flip ) ) {
		$bottom_divider_attr[] = 'shape-divider-reverse-y';
	}
	if ( ! empty( $bottom_divider_height ) ) {
		$unit = preg_replace( '/[0-9.]/', '', $bottom_divider_height );
		if ( ! $unit ) {
			$bottom_divider_height .= 'px';
		}
	}

	$output .= '<div class="' . esc_attr( implode( ' ', $bottom_divider_attr ) ) . '" style="' . ( empty( $bottom_divider_color ) ? '' : 'fill:' . esc_attr( $bottom_divider_color ) . ';' ) . ( empty( $bottom_divider_height ) ? '' : 'height:' . esc_attr( $bottom_divider_height ) . ';' ) . '">';
	if ( 'custom' == $bottom_divider_type ) {
		$output .= rawurldecode( base64_decode( porto_strip_script_tags( $bottom_divider_custom ) ) );
	} else {
		$output .= porto_sh_commons( 'shape_divider' )[ $bottom_divider_type ];
	}
	$output .= '</div>';
}
$output .= '</section>';
$output .= $after_output;

return $output;
